//
//  ColorPicker.swift
//  Do It
//
//  Created by Jim Dovey on 2/4/20.
//  Copyright © 2020 Jim Dovey. All rights reserved.
//

import SwiftUI

fileprivate struct ColorButtonStyle: ButtonStyle {
    func makeBody(configuration: Configuration) -> some View {
        configuration.label
            .overlay(Circle().stroke().foregroundColor(.white))
            .modifier(DoubleShadow(configuration.isPressed ? 1 : 6))
    }
}

struct ColorPicker<Value: ColorInfo>: View {
    @Binding var selectedColor: Value
    var showSelectionBar: Bool = false
    
    var body: some View {
        VStack(spacing: 16) {
            ColorWheel(color: $selectedColor)

            HStack {
                ForEach(Value.predefined) { color in
                    Button(action: { self.selectedColor = color }) {
                        Circle()
                            .fill(color.uiColor)
                    }
                    .accessibility(label: Text(color.localizedName))
                }
            }
            .frame(maxWidth: 500, maxHeight: 40)
            .buttonStyle(ColorButtonStyle())
            .accessibility(label: Text("Color selection"))
            .accessibilityElement(children: .contain)

            if showSelectionBar {
                Rectangle()
                    .foregroundColor(selectedColor.uiColor)
                    .overlay(Rectangle().stroke().foregroundColor(.white))
                    .modifier(DoubleShadow(6))
                    .padding()
                    .frame(maxWidth: 360, maxHeight: 60)
            }
        }
    }
}

struct ColorPicker_Previews: PreviewProvider {
    static var previews: some View {
        StatefulPreviewWrapper(TodoItemList.Color.blue) {
            ColorPicker(selectedColor: $0, showSelectionBar: true)
        }
    }
}
